﻿---
session_code: "BRK310"
title: "Deploying and operating Power Platform solutions with DevOps"
date: "2025-11-20"
speakers:
  - "Casey Burke"
  - "Austin Laugesen"

products:
  - "Microsoft Ignite"

---

# Deploying and operating Power Platform solutions with DevOps
The integration of Power Apps with Azure DevOps and GitHub Actions offers a robust solution for managing deployments, particularly in cross-tenant environments. Here's a structured overview:

1. **Source Control-Based Pipelines**:
   - **Feature Branches**: Developers work on feature branches in Git and deploy changes to environments using release branches.
   - **Release Branches**: These serve as the central point where all changes are merged, allowing for collaborative contributions from multiple developers.

2. **Cross-Tenant Deployments**:
   - Power Apps lacks native cross-tenant capabilities beyond basic deployments, hence the reliance on Azure DevOps or GitHub Actions for more complex scenarios.
   - These tools handle packaging and deployment across tenants efficiently.

3. **Connection Profiles and Service Principals**:
   - These configurations are supported within the source control-based pipelines, maintaining existing functionality while integrating with release branches.

4. **Monitoring and Telemetry**:
   - Integration with Monitor and Open Telemetry is currently limited, but work is underway to enhance this.
   - Currently, copilot studio agents don't support Open Telemetry natively, though efforts are ongoing.

5. **Pipeline Templates**:
   - Pipelines can be templated for reuse across projects or environments, allowing consistent deployment processes.

6. **Challenges and Considerations**:
   - Managing permissions and ensuring thorough testing are important aspects.
   - CI/CD checks may require additional setup beyond the pipeline itself.

7. **AppSource Integration**:
   - No direct integration with AppSource, as it focuses on marketplace apps rather than internal solutions.

In summary, leveraging Azure DevOps or GitHub Actions alongside Power Apps' source control-based pipelines provides a flexible and scalable approach to deployments, especially in cross-tenant environments. Monitoring improvements are anticipated as ongoing projects aim to enhance functionality.
