﻿---
session_code: "BRK293"
title: "From oversharing to oversight: Managing risks in the AI era ​"
date: "2025-11-20"
speakers:
  - "Sophie Ke"
  - "David Minasyan"
  - "Erica Toelle"

products:
  - "Microsoft Ignite"

---

# From oversharing to oversight: Managing risks in the AI era ​
**Final Answer:**

Microsoft's rollout of advanced security and governance features for Microsoft 365 Copilot introduces a comprehensive framework aimed at enhancing AI security, compliance, and organization-wide control. Here's a structured summary of the key points:

1. **Copilot Control System**: This framework offers a centralized approach to managing AI systems, ensuring that they operate within defined policies and comply with regulatory standards. It provides visibility into AI activities, crucial for auditing and monitoring.

2. **Agent Blueprint**: A set of guidelines and best practices for deploying AI agents securely. It covers preparation, security measures for prompts, and ongoing management. Resources like a specific website or QR code are available for detailed information.

3. **Governance and Compliance**: Features such as catalog management and region-specific controls help organize data use and ensure compliance with regulations like GDPR. This supports controlled access and appropriate data usage.

4. **User Training and Awareness**: Essential programs to educate employees on AI security protocols, preventing bypassing of security measures for efficiency.

5. **Feedback Loops and Life Cycle Management**: Continuous improvement through feedback analysis and proactive management of AI models, ensuring decommissioning when models become obsolete or non-compliant.

6. **Scalability and Implementation**: Considerations include setup time, scalability, and continuous monitoring. Case studies and real-world examples could provide insights and challenges.

**Next Steps:**
- Review the Agent Blueprint and Copilot Control System resources.
- Plan training sessions for team members.
- Map current AI use cases to identify gaps and apply controls.
- Research competitors' offerings and implementation case studies for comparative analysis and improvement opportunities.

This approach aims to empower organizations with tools to securely adopt AI, fostering trust in their operations while adhering to regulatory requirements.
