﻿---
session_code: "BRK284"
title: "Reimagine collaboration with multi-user AI"
date: "2025-11-19"
speakers:
  - "Russell Dicker"
  - "Pete Daderko"

products:
  - "Microsoft Ignite"

---

# Reimagine collaboration with multi-user AI
**Answer: Understanding Microsoft Teams AI Enhancements with Teams SDK**

Microsoft Teams offers enhanced AI capabilities through the Teams SDK (formerly Teams AI library), which simplifies creating intelligent agents that can integrate seamlessly into Teams. Here's a structured breakdown of key points and considerations:

1. **Teams SDK Overview**:
   - The Teams SDK provides developers with a unified access point to Microsoft Graph, Bot Builder, and advanced AI features like MCP.
   - It eliminates the need for extensive custom code and deep API knowledge, making it easier to build intelligent bots.

2. **Microsoft 365 Copilot**:
   - Copilot is a significant component that can be integrated into Teams, either from within the app or via a direct invocation action in meetings.
   - It acts as an AI teammate, assisting with tasks, providing insights, and contributing to conversations based on context.

3. **AI Teammates During Meetings**:
   - Agents operate within meeting channels, offering real-time collaboration assistance by automating tasks and providing contextual information.
   - These agents' effectiveness depends on the data they're trained on, often sourced from SharePoint for knowledge-based AI.

4. **Teams SDK Functionality**:
   - The SDK streamlines access to APIs and tools, reducing development complexity.
   - It supports advanced features like richer content generation and adaptive experiences through MCP (Microsoft Convergent Processing), enhancing interaction capabilities.

5. **Authentication and Authorization**:
   - Agents require proper authentication to connect with external tools or systems, such as Asauna.
   - This involves permissions management, typically handled by the organization's admin settings in Teams.

6. **Deployment and Management**:
   - Agents can be deployed as part of specific apps or integrated into existing workflows.
   - Organizations should consider monitoring and management strategies to ensure AI agents function effectively without disrupting operations.

7. **Considerations for Adoption**:
   - Developers should be aware of potential limitations, such as API call thresholds and data privacy concerns.
   - Best practices include thorough testing, user feedback loops, and clear documentation for administrators.

In summary, the Teams SDK empowers developers to create sophisticated AI-driven bots for Microsoft Teams, enhancing collaboration and productivity. Organizations should carefully plan their implementation, considering both technical and governance aspects to maximize benefits while managing potential challenges.
