﻿---
session_code: "BRK270"
title: "Innovating with confidence: Accelerating with Compliance in the age of Agents"
date: "2025-11-19"
speakers:
  - "Sri Lakshmi Kotwal"
  - "Manny Sahota"
  - "Rahul Srivastava"

products:
  - "Microsoft Ignite"

---

# Innovating with confidence: Accelerating with Compliance in the age of Agents
<think>
Okay, so I just watched this video about Microsoft Purview Compliance Manager and how it uses AI-powered regulatory templates to help organizations comply with the EU AI Act. Let me try to break down what I learned.

First, the problem they're addressing is that companies are struggling to keep up with rapidly changing regulations, especially in AI. The EU AI Act is a big deal because it's a comprehensive law covering various aspects of AI development and deployment. Companies need to ensure their AI systems comply, but doing so manually is time-consuming and error-prone.

The solution they present is Microsoft Purview Compliance Manager. This tool uses AI-powered regulatory templates, which are like smart checklists that automatically update with new laws and standards. Instead of manually reviewing documents or codes, the system can scan your systems for compliance issues in real-time. That sounds super efficient!

They also mentioned a case study involving a pharmaceutical company. Before using Microsoft's tools, this company had to slow down every time they wanted to expand their AI models because each expansion was a new risk that needed assessment. Now, with Compliance Manager, they can quickly identify and address compliance issues without delaying innovation.

I'm thinking about how this applies in my work. If we're developing AI models, having a tool that automatically checks against the latest regulations would save so much time. Instead of waiting for updates or manually reviewing each change, the system could handle it all. That also means less room for human error, which is a big plus.

One thing I'm not entirely clear on is how these templates are built. Are they generic, or do they have to be tailored to specific industries? The video mentioned pharma and finance services, so maybe the templates are customizable. If that's the case, it would make them more versatile for different sectors.

Another point is about future-proofing. Since regulations can change quickly, having AI-powered tools that simulate compliance with evolving laws could be really valuable. It allows organizations to prepare in advance rather than reacting after changes are implemented.

I'm also wondering about the integration with other Microsoft products like Power Apps or Dynamics 365. If Compliance Manager integrates smoothly, it might enhance data management and workflow automation even more.

Overall, this seems like a game-changer for compliance teams. By automating the regulatory checklists, companies can focus more on innovation rather than compliance as a bottleneck.
```
