﻿---
session_code: "BRK265"
title: "Secure access for AI agents with Microsoft Entra"
date: "2025-11-18"
speakers:
  - "Alex Simons"
  - "Sharon Chahal"
  - "Ehud Itshaki"

products:
  - "Microsoft Ignite"

---

# Secure access for AI agents with Microsoft Entra
Microsoft's presentation outlines a comprehensive platform called "Agent 365" designed to manage and secure enterprise-level software agents. Here's a structured summary of the key points and concepts discussed:

1. **Enterprise Agent Management**:
   - The platform is focused on managing agents within an organization, providing visibility over all agents to ensure they operate appropriately without posing security risks.

2. **ENTRA Framework**:
   - ENTRA (Enterprise Risk Tolerance and Analysis) likely serves as a framework for determining acceptable risk levels, influencing decisions on how to handle agent activities.

3. **Identity Protection**:
   - This feature flags high-risk identities, such as agents exhibiting suspicious behavior, enabling organizations to monitor and control access effectively.

4. **Conditional Access Policies**:
   - Integrating Azure AD-like policies, Conditional Access ensures that agents only have access to resources they are authorized to use, with access potentially revoked if their risk level increases.

5. **Lifecycle Management**:
   - The system manages the lifecycle of agents, including creation, management, and deactivation, keeping them in a least-privileged state for enhanced security.

6. **Machine Learning and Anomaly Detection**:
   - Utilizes machine learning to analyze agent behavior, detecting anomalies that may indicate risks. Thresholds can be set to determine when an agent's behavior is deemed high risk.

7. **Integration with Ecosystem and Partnerships**:
   - Agent 365 is part of a broader ecosystem, potentially integrating with existing tools like Azure AD. Partner engagement is crucial for developing tailored solutions and extensions, catering to diverse industry needs.

8. **Security Strategy**:
   - The platform offers a layered defense mechanism, combining ENTRA, Identity Protection, and Conditional Access to provide a secure environment for agents while maintaining organizational security.

In essence, Agent 365 presents a proactive approach to managing and securing agents through monitoring, policy enforcement, and automated responses, ensuring a safe operational environment without compromising security.
