﻿---
session_code: "BRK264"
title: "From Risk to Resilience: Secure your AI Agents with Microsoft Defender"
date: "2025-11-20"
speakers:
  - "Ramya Chitrakar"
  - "Moran Gutman"
  - "Asaf Nakash"

products:
  - "Microsoft Ignite"

---

# From Risk to Resilience: Secure your AI Agents with Microsoft Defender
**Securing AI Agents: A Strategic Overview**

**Introduction:**
Organizations are increasingly leveraging AI agents to enhance operations, but securing these agents is crucial due to potential vulnerabilities and risks. Microsoft's approach through Defender and Entra aims to provide comprehensive solutions for this growing landscape.

**Key Components:**

1. **Entra as a Registry:**
   - **Purpose:** Microsoft Entra serves as a centralized registry for both first-party and third-party AI agents, providing a unified identity system.
   - **Benefits:** It allows organizations to track, manage, and assign identities to agents, regardless of their origin.

2. **Defender's Role:**
   - **Posture Management:** Defender CSPM (Cloud Posture and Management) integrates with Entra to detect misconfigurations in cloud environments like AWS and GCP.
   - **Multi-Cloud Coverage:** Defender offers visibility and security across multiple cloud platforms, ensuring comprehensive coverage.

3. **Identity Management:**
   - **Guest IDs and Access Control:** Entra can assign guest identities to discovered agents, enabling enhanced tracking through tools like conditional access, thereby managing permissions and access effectively.

4. **Agent Detection and Monitoring:**
   - **Existing Tools Integration:** Defender integrates with services like Azure ML to monitor AI environments, detecting misconfigurations and suspicious activities.
   - **Shadow AI Mitigation:** Similar to shadow IT, shadow AI refers to undeclared agents; Defender's graph-based approach helps in understanding potential attack paths and incident spread.

5. **Agent Provider Management:**
   - Entra handles different agent providers by normalizing identities across various systems, allowing for unified management and control.

**Conclusion:**
Microsoft's strategy emphasizes proactive security measures for AI agents through tools like Defender and Entra. This approach ensures visibility, identity management, and control, crucial for mitigating risks in an increasingly AI-driven world.
