﻿---
session_code: "BRK262"
title: "AI-powered defense for cloud workloads"
date: "2025-11-20"
speakers:
  - "Parul Seth"
  - "Michael Withrow"

products:
  - "Microsoft Ignite"

---

# AI-powered defense for cloud workloads
**Summary of Microsoft Defender for Cloud Insights**

1. **Integration with Azure AD Premium**: Microsoft Defender integrates seamlessly with Azure Active Directory Premium, enabling cloud-based security tools and identity management solutions.

2. **Rising Security Incidents in M365**: The 89% increase in security incidents highlights the critical need for robust security measures as organizations migrate to the cloud.

3. **Zero Trust Architecture**: Emphasizing the importance of verifying access requests even within networks, this approach aims to prevent insider threats and compromised device damage.

4. **Azure Multi-Tenant Onboarding**: This feature allows managing multiple tenants under one organization, useful for departments or projects on separate M365 instances. It integrates with Defender via the Microsoft Threat Protection (MTP) solution.

5. **Defender Portal and XDR Integration**: Combines cloud security tools with XDR's endpoint monitoring, offering comprehensive threat detection and response through AI-powered solutions.

6. **GCC High and Feature Consistency**: Ensures Defender operates consistently across Azure environments, including GCC High, addressing compliance needs while maintaining security tool access.

7. **Multi-Tenant Management**: Utilizes the Microsoft Threat Protection (MTP) dashboard for a unified view of multiple tenants, enhancing efficiency in security management.

8. **Oracle on Multicloud Roadmap**: Microsoft is expanding Defender's compatibility with platforms like Oracle, aiming for comprehensive multicloud security.

**Key Takeaways**:
- Defender is evolving as a versatile tool for diverse security needs.
- Implementation strategies for Zero Trust and Defender integration require gradual approaches to avoid disruption.
- The focus on proactive security measures is crucial given the increasing cloud adoption and incident rates.

Organizations should consider these points when planning their security strategies, ensuring they adapt to emerging threats and maintain compliance across various environments.
