﻿---
session_code: "BRK246"
title: "Blueprint for Building the SOC of the Future"
date: "2025-11-20"
speakers:
  - "Gary Berletti"
  - "Matt Graham"
  - "Raviv Tamir"

products:
  - "Microsoft Ignite"

---

# Blueprint for Building the SOC of the Future
The evolution of cybersecurity in the age of AI presents both challenges and opportunities. Here's a structured summary of the key points discussed:

1. **Rapid Evolution and Threat Landscape**: 
   - Cybersecurity faces constant changes due to evolving threats and technological advancements, making it crucial for organizations to adapt quickly and efficiently.

2. **Complexity and Limitations of AI**:
   - AI is not a perfect solution; it can make mistakes and may produce complex outputs that are difficult to understand or correct without human intervention.
   - The metaphor of "sock" investigations highlights the risk of AI taking incorrect paths, emphasizing the need for human oversight.

3. **Role of Human Expertise**:
   - Experienced professionals play a crucial role in monitoring AI, much like a seasoned developer reviewing code, ensuring that potential errors are addressed before they become issues.
   - Seniors can save time by identifying common pitfalls, while juniors may benefit from AI's speed but struggle with its complex processes.

4. **Shift in Talent Demands**:
   - The increasing complexity of tasks and reliance on AI is projected to raise the demand for senior talent, who are needed to manage and enhance AI systems.
   - Training juniors to effectively use AI will be essential as they navigate the complexities that AI may introduce.

5. **Implementation and Maintenance Strategies**:
   - AI should not be a one-time solution; it requires continuous maintenance and tuning, necessitating new skills within security teams.
   - Organizations must adopt clear objectives for AI use and establish metrics to evaluate its effectiveness.

6. **Best Practices and Knowledge Sharing**:
   - Embracing a culture of failing fast allows organizations to quickly learn from mistakes and refine their approaches.
   - Encouraging knowledge sharing across industries can help all entities benefit from each other's experiences and best practices.

In conclusion, the integration of AI into cybersecurity requires a blend of advanced technologies with human expertise. Organizations must be vigilant in implementing AI wisely, continuously refining it, and fostering an environment where both AI and human talent thrive.
