﻿---
session_code: "BRK243"
title: "Microsoft Entra: What's New in Secure Access on the AI Frontier"
date: "2025-11-18"
speakers:
  - "Joy Chik"
  - "Nichole Peterson"
  - "John Savill"

products:
  - "Microsoft Ignite"

---

# Microsoft Entra: What's New in Secure Access on the AI Frontier
The session discussed Microsoft's approach to authentication with two primary methods: devicebound pass keys and synced pass keys, both supported by group policies. Here's a structured summary:

1. **Devicebound Pass Keys**:
   - Tied to specific devices or authenticator apps.
   - Example: When using an authenticator app, the pass key works only on that instance, becoming unusable if the device is lost or replaced.
   - Security focus: Limits access points, making credentials harder to recover.

2. **Synced Pass Keys**:
   - Automatically sync across devices and apps supported by ecosystems (e.g., Apple, Google).
   - Must be re-activated on a new device post-loss, but offers convenience for regular users.
   - Integration with password managers allows seamless appearance across devices.

3. **Group Policies**:
   - Administrative controls to assign authentication methods based on user roles (e.g., high-privilege users use devicebound; others use synced).
   - Implementation likely involves management tools like group policy objects or scripts.

4. **Standards and Integration**:
   - Relies on WebAuthn for browser-based interactions, ensuring compatibility across platforms.
   - Microsoft's internal use of synced pass keys for consumer accounts suggests maturity and reliability.

5. **Security Considerations**:
   - Devicebound offers higher security but less convenience; synced is more user-friendly with some trade-offs if multiple devices are at risk.

6. **Practical Implementation**:
   - Admins need to deploy policies that suit organizational needs, possibly using existing systems like Azure AD.
   - User experience is balanced between security and usability, allowing admins to choose the right approach for their users.

In conclusion, Microsoft's authentication strategy provides flexibility with two methods, catering to different security and user convenience needs.
