﻿---
session_code: "BRK240"
title: "Endpoint security in the AI era: What's new in Defender"
date: "2025-11-20"
speakers:
  - "Dana Bargury Shina"
  - "Kim Kischel"

products:
  - "Microsoft Ignite"

---

# Endpoint security in the AI era: What's new in Defender
**Microsoft Predictive Shield: A Comprehensive Overview**

**1. Introduction and Context:**
Microsoft's Predictive Shield is an advanced cybersecurity tool designed to proactively defend against evolving ransomware threats. As ransomware attacks become more sophisticated, traditional security measures are insufficient, necessitating a proactive approach.

**2. Mechanisms of Ransomware Attacks:**
Ransomware typically enters through compromised credentials or phishing, followed by lateral movement within the network to encrypt data and extort payment. Predictive Shield aims to disrupt these stages early to prevent damage.

**3. Components of Predictive Shield:**
- **Unusual Behavior Detection:** Monitors for deviations from normal activity patterns, enabling quick responses to potential threats.
- **Machine Learning Models:** Analyzes data for indicators of compromise, such as unusual login attempts or file hashes matching known ransomware.

**4. Autonomous Hardening Controls:**
Applies security measures automatically, targeting specific vulnerabilities without disrupting legitimate operations. This involves stopping suspicious processes and restricting network access when necessary.

**5. Precision and Minimized Disruption:**
Predictive Shield is designed to be precise, intervening only with high confidence in threats. This reduces the risk of hindering business operations while maintaining security.

**6. Integration and Ecosystem:**
The tool likely integrates with Microsoft's broader security offerings, such as Defender for Endpoint and Azure Active Directory, enhancing protection across hybrid environments.

**7. Role of Human IT Teams:**
Despite its autonomous nature, Predictive Shield provides detailed logs and reports, allowing IT teams to stay involved without being overwhelmed, ensuring a balance between automation and human oversight.

**8. Considerations and Takeaways:**
- **Challenges:** Addressing false positives and accuracy improvement over time.
- **Success Stories:** Potential case studies highlighting effective use in real-world scenarios.

In summary, Predictive Shield offers a proactive defense strategy against ransomware, combining behavior monitoring, ML analysis, and autonomous controls to enhance security while maintaining visibility and control for IT professionals.
