﻿---
session_code: "BRK239"
title: "AI vs AI: Protect email and collaboration tools with Microsoft Defender"
date: "2025-11-20"
speakers:
  - "Ramya Chitrakar"
  - "David Fantham"
  - "Jeff Pinkston"

products:
  - "Microsoft Ignite"

---

# AI vs AI: Protect email and collaboration tools with Microsoft Defender
To effectively detect and respond to sophisticated email campaigns as part of multi-stage attacks, organizations should adopt a comprehensive strategy leveraging advanced tools and threat intelligence. Here's a structured approach:

1. **Understand the Threat Evolution**: Recognize that advanced threat actors are increasingly using legitimate Microsoft 365 tenants for malicious activities. This makes their emails appear more trustworthy.

2. **Leverage AI Tools**:
   - Utilize the "Fish triage agent," an AI tool that can analyze individual emails to determine if they're malicious or benign. This tool can automate responses, such as quarantining suspicious emails.
   - Integrate automated investigation and response tools to expand detection beyond individual emails to entire campaigns.

3. **Implement Multi-Layered Defense**:
   - Use Microsoft Defender for Office to enhance protection against advanced threats.
   - Set up alerts for new tenant creations to detect potential fraudulent activities.
   - Monitor unusual login patterns and high volume email usage to catch early indicators of compromise.

4. **Enhance User Training**: Train users to recognize suspicious emails, especially those appearing from trusted tenants. This helps in identifying malicious attempts even when they look legitimate.

5. **Collaborate with Threat Intelligence Services**: Partner with services that can identify suspicious accounts or activities within Microsoft 365, such as creating fraudulent tenants or sending malicious emails.

6. **Automated Responses**: Implement automated responses to quarantine or block emails identified as malicious, reducing the risk of these threats affecting the organization.

7. **Real-World Implementation**: Look for case studies where organizations have successfully used these tools to mitigate advanced threats, identifying key factors contributing to their success.

8. **Comprehensive Security Strategy**: Address not just email-based threats but also consider broader security strategies to counteract various attack vectors.

By combining these elements, organizations can enhance their resilience against sophisticated attacks, ensuring a robust defense against evolving threats.
