﻿---
session_code: "BRK225"
title: "Unifying your data journey: Migrating to Microsoft Fabric"
date: "2025-11-19"
speakers:
  - "Jenny Jiang"
  - "Mark Kromer"
  - "Priyanka Langade"
  - "Pushpendra Nagtode"

products:
  - "Microsoft Ignite"

---

# Unifying your data journey: Migrating to Microsoft Fabric
<think>
Okay, so I just read through this detailed summary of a talk about migrating Azure Data Factory (ADF) to Azure Fabric. Let me try to process all the information and see what stands out.

First off, there's a lot of emphasis on migration tools and resources. The speaker mentioned several QR codes pointing to different tools: a PowerShell script for data flows, an assessment tool from Bitwise, and some other resources. I guess these are third-party solutions to help with the migration process.

The main focus seems to be on replacing older ADF mappings with newer Fabric-based approaches. They talked about using Spark for data flows, which is a big change from the previous system. So, users will need to rewrite their existing mapping data flows into this new format. That could be challenging, especially if someone isn't familiar with Spark.

There's also an upcoming feature where ADF users can trigger an upgrade assessment directly through the Azure portal. This sounds like it's going to provide a detailed report on what parts of ADF can stay as is and what needs changes. The fact that it's in preview means it might be buggy or not fully featured yet, but it's good for early planning.

Another tool mentioned was from Bitwise, which automatically converts both pipelines and data flows into the new system. That sounds super useful because it could save a lot of manual work. I wonder how reliable this tool is compared to the PowerShell script option.

They also touched on SSIS migration, but that's probably for another time since the focus here was on ADF. Still, it's good to know that these migrations are part of a broader strategy to modernize data integration in Azure.

The mention of the "cloud accelerate factory" program caught my eye too. It sounds like a support program aimed at helping customers through their migration process. Reaching out to Microsoft reps might be crucial for getting the necessary resources and expertise.

I'm trying to think about what this means for someone actually doing the migration. They'll need to assess their current workloads, determine which parts can stay or need changes, and then implement the necessary tools. It's a significant lift, especially if they have a lot of custom logic in their ADF mappings that needs to be reworked into Spark-based data flows.

I'm also curious about how data governance and security are handled during this migration. The original ADF might have specific configurations that need to be carried over correctly into the new environment. Losing those configurations could pose security risks, so it's important that whatever tools they use can handle that transition smoothly.

Another point is the PowerShell script mentioned earlier. Since it's open-source, users might have more control over the migration process. However, without guidance, it could be error-prone. That's where third-party tools and Microsoft support come in handy.

Lastly, I'm thinking about potential pitfalls. Migrations can fail if not properly planned or executed. The speaker stressed that they're here to help, so users should take full advantage of the available resources and support channels. This includes using the assessment tool to find issues early on and then systematically addressing them.

Overall, it seems like a lot is being done by Microsoft to make this transition smoother than it might have been otherwise. The combination of in-house tools, third-party solutions, and support programs should give users a good starting point for their migration journey.
```
