﻿---
session_code: "BRK217"
title: "Resilience by design: Secure, scalable, AI-ready cloud with Azure"
date: "2025-11-20"
speakers:
  - "Gargi Banerjee"
  - "Molina Sharma"

products:
  - "Microsoft Ignite"

---

# Resilience by design: Secure, scalable, AI-ready cloud with Azure
**Azure Resiliency Overview: A Comprehensive Explanation**

**Introduction:**
Azure Resiliency is a strategic approach by Microsoft to ensure that applications and data remain available despite disruptions such as outages or disasters. It encompasses three pillars: infrastructure resiliency, data resiliency, and cyber resiliency, each addressing different aspects of system continuity.

**Key Components:**

1. **Resilience Agent:**
   - A tool designed to automate resilience processes. It likely monitors systems, detects issues, and suggests solutions, reducing the need for manual intervention.
   - Integration with Azure Copilot (an AI assistant) allows for intelligent task management, enhancing efficiency in resilience strategies.

2. **Modes of Consumption:**
   - Offers flexibility in how customers engage with resilience tools. Options include the Azure portal, PowerShell scripts, Terraform, and more, catering to varying technical expertise and preferences.

3. **Azure Site Recovery (ASR):**
   - Enhanced capabilities include higher capacity limits and improved guidance for failover decisions, aiding businesses in efficiently managing their disaster recovery plans.
   - Advanced features like capacity guidance help users determine optimal regions for failover, ensuring efficient resource allocation.

4. **EDLS Gen 2:**
   - An evolution in data resiliency, likely improving backup management and recovery processes, offering more robust solutions for critical data protection.

5. **Thread Detection:**
   - Monitors backups for unusual activity or corruption, enabling early detection and alerting to prevent issues before they impact availability.

6. **Soft Delete for Backups:**
   - Provides a period after deletion where backups can be restored, crucial for accidental deletions and ensuring data recovery without permanent loss.

7. **Available Resources:**
   - Microsoft provides comprehensive documentation and tools within the Azure ecosystem, guiding users from assessment to implementation of resilience strategies.

8. **Assistance Options:**
   - The Azure Accelerate team offers specialized support for customers with bespoke needs, ensuring tailored solutions aligned with individual business goals.

**Conclusion:**
Azure Resiliency is a holistic approach that enhances system reliability through integrated tools and services. By addressing infrastructure, data, and cyber resiliency, Microsoft empowers businesses to build resilient systems that withstand various challenges, ensuring continuity and efficiency in operations. Further exploration of specific features like the Resilience Agent and EDLS Gen 2 can deepen understanding and implementation strategies for organizations looking to enhance their resilience capabilities.
