﻿---
session_code: "BRK202"
title: "Foundry Control Plane: Managing AI agents at scale"
date: "2025-11-19"
speakers:
  - "Mehrnoosh Sameki"
  - "Peter Simones"
  - "Jaspreet Singh"

products:
  - "Microsoft Ignite"

---

# Foundry Control Plane: Managing AI agents at scale
The talk emphasizes the importance of Foundry Control Plane in managing and scaling AI models responsibly. Here's a structured summary:

1. **Purpose and Scope**: 
   - Foundry is part of Microsoft's AI platform, focusing on providing control over complex AI models like LLMs.
   - The goal is to ensure trust and compliance as organizations adopt advanced AI technologies.

2. **Key Features**:
   - **Control Plane**: A management interface for overseeing AI deployments, offering monitoring, auditing, and policy enforcement capabilities.
   - **Responsible AI Toolkit**: Integrates with the control plane to handle scanning, shielding, and steering aspects of AI governance.

3. **Challenges Addressed**:
   - Transition from rule-based assistance to adaptive models requires new management tools.
   - Ensuring governance alignment across teams to avoid delays and issues like inconsistent policies.
   - Standardization in red teaming (ethical testing) and building custom evaluators using domain expertise to enhance trust.

4. **Integration with Security Tools**:
   - Foundry Control Plane's potential includes first-class integration with security tools like Defender, enhancing overall security posture.

5. **Call to Action**:
   - Encourages early customer feedback to shape future versions of the control plane, emphasizing user experience and iterative improvement.

In conclusion, Foundry Control Plane aims to provide a comprehensive framework for managing AI responsibly, ensuring scalability while maintaining trust and compliance.
