﻿---
session_code: "BRK197"
title: "AI powered automation & multi-agent orchestration in Microsoft Foundry"
date: "2025-11-19"
speakers:
  - "Christof Gebhart"
  - "Shawn Henry"
  - "Tina Manghnani"
  - "Mark Wallace"

products:
  - "Microsoft Ignite"

---

# AI powered automation & multi-agent orchestration in Microsoft Foundry
**Step-by-Step Explanation and Considerations for Deploying Microsoft Agent Framework with Foundry**

1. **Understanding the Framework**: The Microsoft Agent Framework leverages GPT-3.5-turbo-pro from OpenAI and Hugging Face Spaces to build multi-agent systems (MAS). It allows composing agents without extensive coding, using existing models.

2. **Setting Up the Environment**: 
   - Install necessary libraries: Python, `openai`, and `requests`.
   - Use VS Code as the development environment for writing code.

3. **Creating the Agent Class**:
   - Define a class with a `__call__` method to handle prompts.
   - Utilize GPT-3.5-turbo-pro for text generation using OpenAI's API.

4. ** Deploying via Docker and Azure Container Instances (ACI)**:
   - Build a Docker image with ACR, including all project dependencies.
   - Push the image to the project's container registry.
   - Create a hosted agent in Foundry by specifying the container image and configuration settings like memory and region.

5. **Managing Agents**:
   - Monitor agents through Foundry's UI where you can stop, delete, or compare different versions.
   - Use Code in VS Code for quick experimentation with automatic environment provisioning.

6. **Integration with Tools**:
   - Potential integration with ChatKit and HUI for building interactive experiences, though specifics were not detailed.

7. **Considerations and Challenges**:
   - **Environment Handling**: Managing different environments and ensuring consistent behavior across deployments.
   - **Versioning and Management**: Understanding how to handle versioning of agents and potential resource constraints.
   - **Performance**: Assessing latency and suitability for real-time applications when using cloud-based agents.

8. **Potential Enhancements**:
   - Exploring under-the-hood integration with Foundry's systems for seamless communication.
   - Evaluating performance trade-offs between cloud-based and local agents.

In summary, deploying an agent involves setting up the environment, defining the agent class, containerizing it, and deploying through Azure services. The process is streamlined by tools like VS Code and Docker, but considerations around environment management and performance are crucial for optimal deployment.
