﻿---
session_code: "BRK192"
title: "Introducing Microsoft Foundry Tools"
date: "2025-11-20"
speakers:
  - "Xiaoying Guo"
  - "Vinod Kurpad"
  - "Linda Li"

products:
  - "Microsoft Ignite"

---

# Introducing Microsoft Foundry Tools
<think>
Okay, so I just finished reading through this transcript from Microsoft's Ignite conference session focused on Azure Cognitive Services like Language, Translator, Speech, etc. The speaker went into a lot of detail about the new features being released. Let me try to process and summarize what I learned.

First, they talked about the new features in Azure Translator. There are now image translation capabilities, which is pretty cool because it can translate text from an image using OCR. Also, there's something called adaptive custom translation, which allows for fine-tuning a model specifically for your data. That makes sense because sometimes generic models might not perform well with unique or niche content.

Then there was mention of the pre-built large translation models that are going to have better performance and quality. This is important because as more data is processed, having efficient tools becomes crucial for scalability.

Moving on to Azure Language Services, they introduced a new entity recognition feature in intent routing, which helps capture context from conversations. That could be really useful for more sophisticated chatbots or applications that need to understand the user's intent better.

In the session, they also touched on updates to Azure Speech. The Phone Aviator support is mentioned, which probably relates to call handling and voice commands. Live interpreter APIs using large language models are also coming out, along with optimizations for real-time processing, which is essential for applications that require immediate responses.

The part about secure redaction tools (PR reduction) stood out too. Being able to mask sensitive information like names or phone numbers in documents adds another layer of security and compliance, especially with regulations like GDPR. The ease of integrating these tools into applications is a big plus because it allows developers to protect data without complicating their code too much.

They also mentioned that all these features will be available soon, possibly within weeks, which is good news for early adoption. The session ended with an encouraging message about building action-oriented agents using these tools to solve real-world problems, emphasizing scalability and confidence in deployment.

I'm trying to think of how these updates could be applied practically. For instance, a company might use image translation to handle receipts or invoices from documents, making the data available for further processing. The adaptive custom translation would help tailor the model to recognize specific jargon or unique terms in their industry. For conversational agents, adding entity recognition could lead to better context understanding, allowing the agent to provide more relevant and helpful responses.

One thing I'm curious about is how exactly the new models compare to previous ones in terms of performance. The speaker mentioned "better performance, better quality, lower latency," but without specific metrics, it's hard to gauge. Also, how does the integration of remote MCP servers work with existing setups? Is there a straightforward way to connect these services without major overhauls?

I'm also thinking about the security aspect—how sensitive information is handled during redaction. It would be important to know what methods are used for masking and whether they comply with industry standards.

Overall, it seems like Microsoft is pushing Cognitive Services further to make AI more accessible and useful across various applications. The emphasis on scalability, security, and ease of integration makes these tools appealing for a wide range of use cases.
</summary>

**Step-by-Step Explanation:**

1. **Azure Translator Updates:**
   - **Image Translation:** Azure Translator can now translate text from images using OCR, expanding its functionality beyond just text-to-text translations.
   - **Adaptive Custom Translation:** This feature allows for the creation of custom translation models tailored to specific datasets, improving accuracy for niche content.

2. **Large Translation Models:**
   - New pre-built models promise better performance and quality, enhancing scalability and efficiency in handling large volumes of data.

3. **Azure Language Services:**
   - **Entity Recognition in Intent Routing:** Enhances conversational agents by better capturing context and user intent, leading to more relevant responses.
   
4. **Azure Speech Updates:**
   - **Phone Aviator Support:** Likely related to voice commands or call handling features.
   - **Live Interpreter APIs:** Utilizes large language models for real-time interpretation and translation during conversations.
   - **Remote MCP Server Integration:** Simplifies the use of secure redaction tools, allowing for easy masking of sensitive information.

5. **Security and Compliance:**
   - Secure redaction tools help protect sensitive data, complying with regulations like GDPR by masking personal information in documents.

6. **Future Directions:**
   - Encouragement to build action-oriented agents that can perform tasks, leveraging these Cognitive Services to solve real-world problems efficiently and securely.

**Conclusion:**

The updates highlight Microsoft's focus on expanding AI capabilities within Azure Cognitive Services, focusing on scalability, security, and usability. These features cater to a broad range of applications, from document processing to conversational interfaces, making AI more accessible and effective for developers and organizations.
