﻿---
session_code: "BRK190"
title: "Monitor, optimize and scale with AI Observability in Microsoft Foundry"
date: "2025-11-19"
speakers:
  - "Abhi Bhatt"
  - "Sebastian Kohlmeier"
  - "Sam Naghshineh"

products:
  - "Microsoft Ignite"

---

# Monitor, optimize and scale with AI Observability in Microsoft Foundry
**Summary of Microsoft Foundry Session: Operations and Management**

1. **Centralized Monitoring with Foundry Control Plane**
   - The session highlighted the Foundry control plane's ability to unify monitoring across all agents, regardless of their origin (Foundry-built or external tools like Google Vertex/AWS Vertex). This centralized approach simplifies oversight and performance management.

2. **External Agent Integration**
   - The operation tab allows for integrating traces and logs from external sources using OpenTelemetry semantics, ensuring comprehensive visibility into agent activities across various environments, including on-premises and cloud setups.

3. **Issue Detection and Insights**
   - Demonstrated how Foundry can detect issues like hallucination in agents by analyzing input-output pairs. This feature aids in troubleshooting and improving agent performance.

4. **Scheduled Evaluations and Red Teaming**
   - Features like hourly/daily scheduled evaluations and red teaming runs enable continuous monitoring and stress-testing, ensuring robustness and reliability.

5. **Efficient Troubleshooting with Utilities**
   - Foundry's utilities help identify specific issues in agent behavior, allowing for quick fixes by drilling down into detailed evaluation data.

6. **Scalability and Considerations**
   - Potential challenges include integrating agents from various third-party platforms and ensuring scalability for large numbers of agents or complex models. Cloud-native tools suggest good scaling capabilities, but real-world performance metrics would be valuable.

7. **Documentation and Feedback**
   - Emphasis was placed on using documentation and user feedback to continuously improve the platform, ensuring that users can effectively utilize and contribute to enhancements.

Overall, Microsoft Foundry offers a comprehensive solution for managing AI/ML workloads, combining ease of use with powerful monitoring and analysis capabilities.
