﻿---
session_code: "BRK178"
title: "Architecting for resiliency on Azure Infrastructure"
date: "2025-11-20"
speakers:
  - "Eric Henry"
  - "Sudha Mahajan"
  - "Jon Ormond"

products:
  - "Microsoft Ignite"

---

# Architecting for resiliency on Azure Infrastructure
To enhance your application's resilience using Azure's shared responsibility model, follow this structured approach:

1. **Define Availability Targets**: Establish clear targets based on business requirements. For instance, financial applications may require 99.9% availability, while others might need less stringent levels.

2. **Set Recovery Objectives**:
   - **Recovery Time Objective (RTO)**: Determine how quickly your application should recover from a failure.
   - **Recovery Point Objective (RPO)**: Define the maximum acceptable data loss. Use formulas or industry standards, such as those from Microsoft's well-architected framework, to guide your decisions.

3. **Engage with Microsoft**:
   - Schedule meetings with your Microsoft account team to align your architecture with best practices and share your resiliency needs.
   - Review the well-architected framework for guidelines that can optimize your application's structure.

4. **Implement Resiliency Strategies**:
   - **Zone-Level Redundancy**: Deploy your application across multiple zones to protect against localized failures, relying on Azure to manage traffic distribution.
   - **Multi-Region BCDR**: Setup your app in multiple regions and use Azure Traffic Manager to reroute users to the nearest healthy region during regional outages.

5. **Layered Approach**:
   - Combine zone-level redundancy for local issues with multi-region BCDR for broader disruptions, ensuring a robust defense against different types of failures.

6. **Workload Classification**: Categorize your applications as mission-critical or standard. Apply higher resiliency measures to mission-critical apps and basic protections to others, based on business impact analysis.

7. **Monitor and Improve**:
   - Utilize tools like Azure Monitor and Application Insights to continuously assess and enhance your application's resilience.
   - Regularly review performance metrics to ensure optimal operation and adapt as needed.

By systematically addressing each component, you can create a resilient application aligned with Azure's shared responsibility model, ensuring high availability and quick recovery from disruptions.
