﻿---
session_code: "BRK172"
title: "Powering modern cloud workloads with Azure Compute"
date: "2025-11-21"
speakers:
  - "Stefanie Lemon"
  - "Max Uritsky"

products:
  - "Microsoft Ignite"

---

# Powering modern cloud workloads with Azure Compute
**Summary of Azure Boost and Related Concepts**

Azure Boost is a feature within Microsoft Azure that enhances the performance and security of virtual machines (VMs) by optimizing infrastructure based on workload requirements. Here's a breakdown of key points discussed:

1. **Workloadcentric Approach**: This refers to tailoring the infrastructure to meet specific needs of different workloads, ensuring efficiency and reliability across various computing tasks.

2. **Mana and Envy**: These terms likely refer to tools or configurations for network management and environment setup, respectively. They are recommended as best practices for optimizing performance and security in Azure environments.

3. **Azure Boost Functionality**:
   - Enhances VM performance by leveraging specific configurations.
   - Integrates with hardware improvements from AMD and Intel, contributing to Confidential Computing (TCB) enhancements.
   - Focuses on secure data handling without the need for a bounce buffer, ensuring data remains within a trusted computing area.

4. **Confidential Computing (CC)**: Azure Boost extends TCB boundaries by integrating securely with Azure Boost, allowing direct communication between VMs and hardware without compromising security.

5. **DPDK Recommendations**: The Data Plane Development Kit is suggested for network and data optimizations, enhancing overall infrastructure performance.

6. **Significance of ABCD**: This acronym might represent a specific feature or standard within Confidential Computing, contributing to its mainstream adoption after years of development.

In essence, Azure Boost is a significant enhancement in Azure's capabilities, offering improved performance and security through optimized VM configurations and partnerships with leading hardware providers, making it a crucial tool for modern data processing needs.
