﻿---
session_code: "BRK1706"
title: "Innovation Session: Build & Manage AI Apps with Your Agent Factory"
date: "2025-11-18"
speakers:
  - "Yina Arenas"
  - "Sarah Bird"
  - "Amanda Silver"
  - "Marco Casalaina"

products:
  - "Microsoft Ignite"

---

# Innovation Session: Build & Manage AI Apps with Your Agent Factory
<think>
Alright, I need to summarize this talk about Microsoft's Foundry platform. Let me start by recalling what I heard.

The presenter, Amanda, talked a lot about how Foundry is changing the way developers work with AI. It seems like it's designed to make building and managing AI models easier, especially for enterprises. She mentioned something about reducing the "scaffolding" and operational aspects so developers can focus more on creative tasks.

She emphasized the shift from writing code to articulating intent. That makes sense because AI models need clear directives rather than just code snippets. I remember her saying that developers are becoming orchestrators, designing specs, guiding agents, and validating outcomes. This suggests a move towards more strategic roles rather than just coding.

Amanda also highlighted the integration with existing tools like Azure, which is important for organizations already invested in Microsoft's ecosystem. She mentioned connectors to systems like SAP and Salesforce, showing that Foundry can integrate with legacy systems as well. That’s crucial because enterprises often have established infrastructure.

She talked about using GitHub Copilot with Foundry to automate evaluations of AI agents. This helps maintain code quality by continuously improving models through evaluations automatically integrated into CI/CD pipelines. That's a big plus for maintaining reliable AI solutions without manual intervention.

Another key point was the focus on governance and security, which is a big concern for enterprises. She mentioned Azure services providing scale and security, ensuring that Foundry fits into compliance-heavy environments.

She also touched on the creative aspect of AI development, suggesting that while developers might spend less time coding, they can be more innovative. This aligns with the idea that AI tools should empower developers to build better applications without getting bogged down by technicalities.

I think I got most of it, but maybe I missed some details about specific features or use cases. She also invited attendees to engage through workshops and resources, which shows a commitment to helping users implement Foundry effectively.

Overall, Foundry seems to be positioning itself as an end-to-end platform for building AI solutions that are scalable, secure, and aligned with business goals, making it accessible and valuable for both individual developers and large organizations.
```
