﻿---
session_code: "BRK157"
title: "Best practices for migration and security with Azure VMware Solution"
date: "2025-11-19"
speakers:
  - "Sundeep Hiranandaney"
  - "Justin Jakowski"

products:
  - "Microsoft Ignite"

---

# Best practices for migration and security with Azure VMware Solution
**Azure VMware Solutions: Bridging Existing Infrastructure with Cloud Benefits**

1. **Introduction to Azure VMware Solution**
   - Azure VMware Solution serves as a strategic choice for organizations looking to integrate with Microsoft Azure without transitioning away from their existing VMware environment. This allows companies to leverage their current virtualization investments while adopting cloud capabilities.

2. **Key Capabilities**
   - **Consistent Infrastructure:** Enables seamless operation of VMware environments on Azure, maintaining existing configurations and operational practices.
   - **Advanced Security:** Utilizes VMware NSX for enhanced security features, including micro-segmentation, providing robust protection against threats.
   - **Network Virtualization:** Employs NSX to create and manage software-defined networks, enhancing agility and scalability.
   - **Cloud-Native Applications:** Integrates with Azure Kubernetes Service (AKS), allowing cloud-native applications to coexist with existing VMware workloads in a hybrid environment.
   - **Workload Migration:** Facilitates the migration of on-premises workloads to the cloud using tools like Azure Migrate, ensuring efficient and optimized transitions.
   - **Optimization Tools:** Provides tools for storage optimization and cost management, helping users enhance efficiency and reduce costs.

3. **Security Measures**
   - **Surround Security:** Implements Web Application Firewalls (WAF) and Azure Firewall to protect web traffic and network security, combating threats like SQL injection and DDoS.
   - **Micro-Segmentation:** Enhances security by applying granular policies to individual workloads using both NSX and Azure Firewall.

4. **Future Opportunities**
   - Participate in surveys for storage insights and enter a sweepstakes for $500.
   - Engage with product experts at the VMware booth and explore click-through demos for hands-on insights into solution capabilities.

In essence, Azure VMware Solution empowers organizations to enhance their existing VMware infrastructure by integrating cloud-native tools and security features, offering a strategic path towards hybrid cloud computing.
