﻿---
session_code: "BRK156"
title: "How Levi’s is transforming their IT estate with Azure"
date: "2025-11-19"
speakers:
  - "Maria Bledsoe"
  - "Shawn Harris"
  - "Michael Womack"

products:
  - "Microsoft Ignite"

---

# How Levi’s is transforming their IT estate with Azure
The organization's cloud migration journey highlights several key strategies and lessons learned, which can serve as a comprehensive guide for others embarking on similar projects. Here is an organized summary of their approach and insights:

1. **Right-Sizing**: 
   - Ensure servers and VMs are appropriately sized to avoid over-provisioning, optimizing both performance and costs.

2. **Migration Tools**:
   - Utilize tools provided by the cloud service (e.g., Azure site recovery) to facilitate smooth workload transitions and minimize downtime.

3. **Licensing and Costs**:
   - Conduct thorough research on licensing requirements early in the process to avoid costly surprises later. Be prepared to adjust configurations based on these needs.

4. **Regular Check-ins**:
   - Maintain regular communication with cloud teams, customers, and security experts to ensure smooth operations and catch missed optimizations or savings opportunities.

5. **Security First**:
   - Implement a zero trust model from the start and work closely with security experts to continuously improve protection measures.

6. **Challenges and Solutions**:
   - Address issues like firmware upgrades by relying on cloud infrastructure for automatic maintenance.
   - Focus on secure communication channels (private endpoints, links) to safeguard data integrity.

7. **Project Management**:
   - Break down the migration process into phases to manage large-scale projects effectively, especially when considering long-term timelines like 2026.

8. **Lessons Learned**:
   - Be flexible and allow room for improvement based on feedback and results.
   - Avoid being too strict initially; adjust approaches as the project evolves.

9. **Disaster Recovery Plan**:
   - Develop a robust plan to handle unexpected issues during migration, ensuring business continuity through effective disaster recovery strategies.

10. **Application Compatibility**:
    - Ensure applications are compatible with the cloud environment from the start by conducting thorough checks and necessary adjustments.

By integrating these strategies, the organization successfully navigated their migration journey, demonstrating a model for others in how to approach cloud transitions thoughtfully and efficiently.
