﻿---
session_code: "BRK155"
title: "Sam’s Club transforms retail mission-critical apps with Azure"
date: "2025-11-20"
speakers:
  - "Gautam Chandra"
  - "Justine Cocchi"

products:
  - "Microsoft Ignite"

---

# Sam’s Club transforms retail mission-critical apps with Azure
**Modernization of a .NET Application: Key Insights**

1. **Design Principles:**
   - **Isolation:** Ensure services are independent to prevent cascading failures.
   - **Regional Independence and Duplication:** Mirror data across regions for disaster recovery, balancing cost and latency.

2. **Resiliency Patterns:**
   - **Circuit Breakers:** Protect the system from cascading failures by failing fast at critical points.
   - **Retry Mechanisms:** Handle transient errors by retrying operations a limited number of times before declaring failure.
   - **Bulk Operations Handling:** Use retries to manage database operations that require strong consistency.

3. **Scalability:**
   - **Auto-Scaling Groups:** Automatically adjust resource allocation based on traffic.
   - **Load Balancing:** Distribute traffic evenly across servers to prevent overload.
   - **Caching Strategies:** Use Redis or Dgraph for efficient data access, ensuring high-speed performance without overloading databases.

4. **Monitoring and Maintenance:**
   - **Observability Pillars:** Utilize metrics, logs, and traces for comprehensive system insights.
   - **Tools:** Implement App Insights and Grafana for visualization and troubleshooting.

5. **Implementation Considerations:**
   - **Circuit Breakers:** Wrap API calls with retry logic and implement circuit breaker patterns around critical components.
   - **Distributed Tracing:** Use DTH to correlate traces across microservices, ensuring end-to-end request tracking.
   - **NetAspire Integration:** Centralize observability with tools like Aspire Dashboard for easy access to metrics and logs.

6. **Scalability Beyond Auto-Scaling:**
   - Explore custom scaling strategies for complex workloads, possibly combining auto-scaling with third-party solutions.

7. **Caching Strategies:**
   - Implement best practices to avoid cache invalidation issues, ensuring efficient data management in microservices environments.

**Conclusion:** Modernizing an application focuses on enhancing resiliency, scalability, and observability. Each aspect requires careful implementation, balancing performance, cost, and maintainability.
