﻿---
session_code: "BRK147"
title: "What’s new in Azure Local"
date: "2025-11-20"
speakers:
  - "Meena Gowdar"
  - "Mohamed Khalid"
  - "Dean Paron"

products:
  - "Microsoft Ignite"

---

# What’s new in Azure Local
**Azure Local: Bridging On-Premises and Cloud Environments**

**Overview:**
Azure Local is a strategic tool for companies aiming to extend their cloud capabilities on-premises, offering a hybrid solution that simplifies management, enhances security, and streamlines operations. It leverages Azure Arc to manage resources across both environments from a single platform.

**Key Benefits:**

1. **Consistent Security Policies:**
   - Ensures compliance with strict regulatory standards by maintaining uniform security protocols whether data resides on-prem or in the cloud.
   - Utilizes tools like Azure Defender and CloudNAP for robust security posture management.

2. **Self-Service Models:**
   - Provides developers and researchers with seamless access to resources, reducing manual intervention and operational bottlenecks.
   - Offers a consistent user experience across environments, enhancing efficiency and innovation.

3. **Factory Integration Layer:**
   - Facilitates data transfer from manufacturing plants (via IoT devices or other methods) to the cloud for real-time insights, improving productivity and supply chain efficiency through analysis and decision-making.

4. **Cost Management and Future-Proofing:**
   - Enhances financial transparency with resource tagging and cost allocation capabilities.
   - Supports future innovations such as AI services and advanced analytics by building a scalable, adaptable infrastructure.

5. **Hybrid Governance and Collaboration:**
   - Centralized governance and management across environments reduce operational overhead.
   - Requires collaboration from various teams (security, compliance, networking) to ensure smooth integration and security.

**Considerations and Questions:**

- **Data Collection Methods:** Typically involves IoT devices or specific on-premises sensors collecting data for transfer to the cloud.
- **System Integration:** Utilizes tools like Azure Arc and other Azure services to ensure compatibility with existing systems, often involving assessment of current infrastructure before integration.
- **Scalability:** Utilizes Azure's scalable architecture, allowing dynamic adjustments in resource allocation based on workload demands.
- **Governance Across Environments:** Employs centralized dashboards or automation tools for consistent policy enforcement across on-prem and cloud environments.

**Conclusion:**
Azure Local serves as a crucial enabler for digital transformation by providing a seamless bridge between on-premises and cloud infrastructures. It supports innovation while maintaining security and compliance, making it a valuable tool for organizations seeking to modernize their IT strategies.
