﻿---
session_code: "BRK146"
title: "Resiliency and recovery with Azure Backup and Site Recovery"
date: "2025-11-21"
speakers:
  - "Rochak Mittal"
  - "Rohan Sahini"

products:
  - "Microsoft Ignite"

---

# Resiliency and recovery with Azure Backup and Site Recovery
**Azure Resilience and Recovery: Key Takeaways**

1. **Azure Backup Enhancements**:
   - Azure Backup integrates with tools like the Resiliency Agent and Copilot to enhance data protection and security.
   - Copilot automates security configuration improvements for vaults, ensuring they meet standards without manual intervention.

2. **Azure Site Recovery (ASR) Updates**:
   - ASR supports disaster recovery for virtual machines, including crash-consistent agentless backups, which are particularly useful for Linux users who prefer minimal software installations.
   - ASR now recommends alternative VM sizes during recovery to avoid capacity issues, ensuring smooth transitions.

3. **Resiliency Orchestration Expansion**:
   - The Resiliency Agent is being developed to manage recovery policies across various workloads, including databases and potentially Kubernetes clusters in the future, expanding beyond VM-based recovery.

4. **Copilot's Role in Automation**:
   - Copilot facilitates both protection expansion (e.g., enabling ASR for existing backups) and security posture enhancement (automating vault configuration improvements).

5. **Azure ADLS Gen 2 Integration**:
   - While the exact role of Azure ADLS Gen 2 in backup and recovery wasn't fully clarified, it likely pertains to managing metadata or data storage aspects related to resilience.

6. **Future Outlook**:
   - Microsoft is continuing to develop these tools, with a focus on making resilience and recovery more automated and user-friendly.
   - Keep an eye on Azure updates for the rollout of new features like Copilot and Resiliency Agent.

In summary, Microsoft's focus is on creating seamless, intelligent solutions for data protection and recovery, leveraging automation to simplify management for enterprises.
