﻿---
session_code: "BRK142"
title: "Preparing and modernizing Windows Server workloads in Azure"
date: "2025-11-18"
speakers:
  - "Dan Cuomo"
  - "Jeff Woolsey"

products:
  - "Microsoft Ignite"

---

# Preparing and modernizing Windows Server workloads in Azure
**Summary of Key Points from the Ignite 2025 Talk on Azure Arc and Windows Server**

1. **Hybrid Cloud Solutions**: Customers require hybrid environments where cloud solutions (like Azure SAS, PAZ, IAS) are complemented by on-premises infrastructure. This hybrid approach is essential for businesses aiming to integrate cloud and on-prem capabilities.

2. **Consistent Monitoring and Security**: By enabling Azure Arc on Windows Server HyperV in V mode, organizations can manage their virtual machines (VMs) both on-prem and in the cloud using tools like Defender for Cloud. This ensures a consistent monitoring and security experience across environments.

3. **Azure Arc as a Connector**: Azure Arc serves as a connector that provides unified management of servers, whether they are located in branch offices or data centers globally. This allows for centralized management and visibility.

4. **V Mode Public Preview**: The V mode, part of the public preview, extends HyperV into a cloud-managed environment, enabling enhanced hypervisor and virtualization fabric capabilities. The documentation is available at aka.mwackvdocs, with resources for further exploration.

5. **Migration Support**: Microsoft offers support to help customers migrate from older platforms like Windows Server 2012 R2 to newer versions such as 2025, utilizing tools like Azure Migrate for assessment and planning. Direct upgrades from 2012 R2 to 2025 are possible in one hop.

6. **Modernization Initiatives**: Encouraging the modernization of workloads and infrastructure is key. Upgrading to Windows Server 2025 is highlighted as a significant step, supported by tools like Azure Migrate and Windows Admin Center for management.

7. **VM Conversion Tool Testing**: The VM conversion tool is available in public preview, with resources at aka.mwackvdocs guiding users through the process. This tool aids in transitioning workloads to cloud environments efficiently.

8. **Booth Availability**: Microsoft representatives are present at the booth to assist with questions, offering more information on V mode, Azure Arc, and migration assistance.

**Conclusion**: The talk emphasizes the importance of hybrid management, modernization, and leveraging tools like Azure Arc and Windows Admin Center for efficient server management across cloud and on-premises environments.
