﻿---
session_code: "BRK137"
title: "Nasdaq Boardvantage: AI-driven governance on PostgreSQL and Microsoft Foundry"
date: "2025-11-19"
speakers:
  - "Charles Feddersen"
  - "Mohsin Shafqat"

products:
  - "Microsoft Ignite"

---

# Nasdaq Boardvantage: AI-driven governance on PostgreSQL and Microsoft Foundry
**Microsoft's Approach to AI with PostgreSQL and Vector Search: A Summary**

Microsoft has implemented a robust solution leveraging PostgreSQL with Vector Search technology to enhance their AI applications. Here's an organized overview of their approach:

1. **AI Solutions Overview**:
   - Microsoft focuses on tools like Board Assistant and Document Intelligence, which process text data (meeting minutes, documents) into structured outputs or summaries.

2. **Technology Stack**:
   - Utilizes PostgreSQL for efficient storage and querying.
   - Incorporates Vector Search, likely using open-source libraries like FAISS or Annoy, to enable similarity-based operations such as finding related concepts.

3. **Workflow Mechanics**:
   - Extracts embeddings from text during preprocessing.
   - Stores these embeddings in PostgreSQL with Vector Search, allowing efficient queries.
   - Embeddings are deleted post-query to optimize storage.

4. **Integration and Deployment**:
   - Integrates AI models with PostgreSQL, potentially using Azure Cognitive Services for regional deployment.
   - Manages scaling challenges through techniques like auto-scaling to handle fluctuating query loads.

5. **Evaluation and Metrics**:
   - Uses deep eval to validate AI responses against public documents, ensuring performance and accuracy metrics are met.
   - Monitors biases, toxicity, and relevance to maintain ethical standards.

6. **Infrastructure and Scalability**:
   - Leverages PostgreSQL's high availability for data integrity and disaster recovery via cross-region replication.
   - Addresses storage and compute needs with efficient management strategies.

7. **Use Cases and Considerations**:
   - Potential applications in customer support, legal documents, and financial analytics.
   - Exploring open-source components or SDKs for broader community adoption.
   - Managing model updates without operational disruption.

8. **Conclusion**:
   - Combines traditional databases with modern vector search, offering scalable and reliable AI solutions.
   - Emphasizes ethical considerations through comprehensive evaluation metrics.

This approach highlights Microsoft's strategic use of existing infrastructure to build efficient, trustworthy AI tools that meet real-world demands.
