﻿---
session_code: "BRK116"
title: "Apps, agents, and MCP is the AI innovation recipe"
date: "2025-11-19"
speakers:
  - "Devanshi Joshi"
  - "Nir Mashkowski"
  - "Jordan Selig"
  - "Jun Yoshida"

products:
  - "Microsoft Ignite"

---

# Apps, agents, and MCP is the AI innovation recipe
<think>
Okay, so I just went through this lengthy transcript of a presentation about AI innovation using something called the Microsoft Agent Framework. Honestly, it's a bit overwhelming because there's so much technical jargon and concepts that I'm not fully grasping yet. But let me try to break it down step by step.

First off, the presenter starts by talking about "the essential ingredients in the AI innovation journey for your existing application." They mention streamlining code modernization and making existing apps intelligent without being an AI expert. That part resonates with me because I know a lot of businesses want to integrate AI but don't have the expertise or time to rewrite everything from scratch.

They then go into more detail about how to make existing apps intelligent by infusing AI experiences. The example given is using Azure functions and agent frameworks to create multi-tenant systems, which I think means the system can handle multiple users or contexts efficiently. This part seems practical because it suggests that you don't have to overhaul your current setup but instead enhance it with AI features.

The next big topic is about using existing application compute services like app service or functions without changing anything in the compute infrastructure. This is appealing because businesses don't want to deal with migration costs or downtime. Instead, they can just layer on new capabilities, which is more cost-effective and less risky.

Security is also emphasized as a core part of this approach. The presenter mentions that security is now easier with Azure's services, ensuring that MCP (Microsoft Compute) servers are safeguarded across different platforms like app service, functions, or container apps. This makes me think about how important it is to protect AI systems from vulnerabilities, especially since they often handle sensitive data.

They wrap up by talking about a demo where an AI system detects a problem with an air compressor and gives guidance to the maintenance engineer. This real-world example helps illustrate how the framework can be applied to solve specific issues in manufacturing or other industries. The idea of providing actionable steps for maintenance engineers is pretty cool because it shows tangible benefits.

In the end, they encourage attendees to join for more questions and participate in a lab session the next day. They also mention that the demo scenario can be tried out in one's own environment, which is great for hands-on learning.

As someone new to AI frameworks, I'm trying to figure out how all these pieces fit together. The Microsoft Agent Framework seems like a powerful tool because it allows businesses to enhance their existing systems without a complete overhaul. It's about adding intelligence where it matters most, using tools that are scalable and adaptable. The mention of multi-tenant systems and orchestration makes me think of scalability and the ability to handle varying demands efficiently.

I'm still unclear on how exactly the AI agents work within the framework. They mentioned product description agents, status explanation agents, and failure protection agents. I suppose these are like different modules that perform specific tasks, but I'd need more examples or diagrams to fully understand their interactions. Also, the integration with Azure functions and other Microsoft services is a bit abstract to me. How exactly do they communicate and share data?

Security-wise, it's reassuring to know that Azure provides tools to handle this, but I wonder how complex it is to set up these safeguards for different parts of the system. If there are multiple agents accessing various services, how does that affect security? Are there built-in monitoring tools, or do they need to be integrated separately?

Another thing I'm thinking about is the cost-effectiveness. The presenter mentioned reducing infrastructure costs with serverless functions, which makes sense because you only pay for what you use. But are there any hidden costs when integrating AI agents and orchestrating them? How does the total cost of ownership compare to traditional methods?

I also wonder about the implementation process. How long does it typically take to set up an environment using Azure functions and agent frameworks? Is there a step-by-step guide or tool that facilitates this process, especially for someone who isn't an AI expert but needs to deploy these agents?

Overall, I'm convinced that this framework is a promising approach for businesses looking to enhance their applications with AI without major overhauls. But I need more detailed information on how the agents are structured, how they interact, and how security is managed in such setups.
```
