﻿---
session_code: "BRK113"
title: "Connected, managed, and complete agentic apps with Microsoft Foundry"
date: "2025-11-19"
speakers:
  - "Robert Finlayson"
  - "Shawn Henry"
  - "Mike Hulme"
  - "Balan Subramanian"

products:
  - "Microsoft Ignite"

---

# Connected, managed, and complete agentic apps with Microsoft Foundry
**Microsoft Foundry: A Comprehensive Solution for AI-Driven Automation**

Microsoft Foundry offers a unified platform designed to empower enterprises with intelligent agents, enhancing operational efficiency and decision-making through AI-driven automation. Here's an organized overview of the key components and functionalities discussed:

1. **Building Intelligent Agents:**
   - Foundry enables the creation of agents that can reason independently, utilizing machine learning models to perform tasks like data analysis and decision-making.
   - These agents can be developed using code or via the Foundry portal, providing flexibility for different development approaches.

2. **Integration with Business Processes:**
   - Logic Apps integrate these agents into workflows, allowing them to automate tasks and interact seamlessly with existing systems, whether on-premises or cloud-based.
   - Agents can perform actions based on predefined rules or ML models, streamlining business processes and reducing manual intervention.

3. **Governance and Control:**
   - The Foundry Control Plane serves as the governance hub, providing centralized management of agents through the AI Gateway (Azure API Management).
   - This gateway enforces policies such as rate limits, data constraints, and access control, ensuring security and compliance across all agents uniformly.

4. **Cross-Environment Deployment:**
   - Agents can be deployed across various environments, including on-premises and cloud platforms like AWS and GCP. The Foundry Control Plane manages traffic to these agents, ensuring consistent policies are applied regardless of their location.

5. **Teams of Agents:**
   - Agents can collaborate by calling each other or working on subtasks, creating complex workflows where diverse expertise is leveraged for comprehensive problem-solving.

6. **Integration and Security:**
   - Logic Apps facilitates connections to on-premises data sources, handling authentication and authorization to ensure secure interactions with business systems.
   - The control plane ensures hybrid scenarios are managed effectively, maintaining performance and security across different environments.

7. **Success Measurement:**
   - Success is measured through metrics such as accuracy, processing speed, cost efficiency, and user adoption, with a focus on how agents improve processes and reduce manual work.

**Conclusion:**
Microsoft Foundry presents a robust solution for enterprises looking to adopt AI-driven automation. Its comprehensive approach ensures scalability, security, and governance, making it ideal for integrating intelligent capabilities across diverse operational environments.
