﻿---
session_code: "BRK109"
title: "Ship faster. Stress Less. Idea to ops with Azure and GitHub Copilot"
date: "2025-11-20"
speakers:
  - "Nir Mashkowski"
  - "Mandy Whaley"

products:
  - "Microsoft Ignite"

---

# Ship faster. Stress Less. Idea to ops with Azure and GitHub Copilot
The video introduces a comprehensive set of tools designed to enhance the development workflow on Azure, particularly through integration with VS Code and Minecraft Command Prompt (MCP). Here's a structured overview of the key points and insights:

1. **Overview of Tools**:
   - **VS Code Extensions**: The AI Toolkit, Azure Tools, and MCP Server are extensions for VS Code that provide advanced functionalities.
   - **S Surfer**: Likely a plugin or tool used within VS Code, possibly integrating Minecraft mechanics into coding workflows.

2. **Minecraft Command Prompt (MCP)**:
   - Likely a command-line tool or environment used within Minecraft to execute commands, aiding in code execution and management.

3. **AI Toolkit**:
   - Facilitates the creation of AI-driven agents using pre-trained models from a model catalog.
   - Enhances development by automating tasks and providing intelligent suggestions.

4. **Azure Live Logs**:
   - Streams application logs in real-time, aiding in issue detection and debugging.

5. **GitHub Integration**:
   - Automatically opens GitHub issues and pull requests when errors or changes are detected, likely triggered by Azure Live Logs.
   - Suggests fixes, potentially using Copilot for assistance.

6. **Copilot's Role**:
   - Contributes to issue creation and PR management by analyzing logs and suggesting fixes.
   - Can update Bicep files for infrastructure as code, demonstrating its versatility in automation.

7. **Getting Started**:
   - Install VS Code extensions (Azure Tools, AI Toolkit) to access features like Live Logs and Copilot.
   - Set up MCP Server, which may require specific Minecraft versions, possibly 1.18.x.
   - Explore integration points between tools for a deeper understanding of automation processes.

8. **Development Workflow**:
   - Automation of deployments, issue detection, and code fixes through AI-driven agents and real-time log analysis.
   - Real-time feedback and error handling, enhancing productivity.

9. **Considerations**:
   - Further exploration is needed to understand exact mechanisms, setup, and integration points.
   - Potential for using pre-trained models in VS Code for rapid development.

In conclusion, the video showcases a powerful ecosystem of tools that streamline and enhance Azure development workflows. By integrating with VS Code and leveraging AI, these tools offer significant potential for automating and optimizing tasks, making them valuable for developers looking to enhance their productivity.
