﻿---
session_code: "BRK102"
title: "Technical deep dive on Managed Instance for App Service"
date: "2025-11-19"
speakers:
  - "Scott Hunter"
  - "Gaurav Seth"
  - "Andrew Westgarth"

products:
  - "Microsoft Ignite"

---

# Technical deep dive on Managed Instance for App Service
**Answer:**

Moving legacy applications to Azure App Service using managed instances offers a seamless transition with minimal code changes, leveraging the power of containerization and abstraction. Here's how it works:

1. **Containerization**: Legacy applications are packaged into Docker containers, allowing them to run consistently across different environments without significant code modifications.

2. **API Exposure**: Legacy apps can utilize APIs hosted on managed instances, enabling integration with modern services and workflows without altering their core functionality.

3. **Infrastructure Abstraction**: Azure App Service handles the underlying infrastructure, including scaling and maintenance, allowing developers to focus on application logic and performance.

4. **Compatibility and Dependencies**: While legacy apps may require some adjustments for containerization, existing dependencies and external APIs can be managed within the Azure environment.

5. **Scalability and Performance**: Managed instances automatically adjust resources based on demand, ensuring efficient scaling without manual intervention.

6. **Security Considerations**: Moving to Azure enhances security through built-in compliance tools and practices, helping organizations meet new standards while maintaining existing security protocols.

7. **DevOps Efficiency**: Containerized environments streamline CI/CD pipelines, making deployments faster and more reliable.

In conclusion, managed instances on Azure App Service provide a cost-effective and efficient way to modernize legacy applications with minimal changes, enhancing scalability, performance, and security.
